/*
 * Decompiled with CFR 0.152.
 */
package io.github.fabricators_of_create.porting_lib.transfer.item;

import io.github.fabricators_of_create.porting_lib.core.util.INBTSerializable;
import io.github.fabricators_of_create.porting_lib.transfer.item.ItemStackHandlerSlot;
import io.github.fabricators_of_create.porting_lib.transfer.item.SlottedStackStorage;
import io.github.fabricators_of_create.porting_lib.util.DualSortedSetIterator;
import io.github.fabricators_of_create.porting_lib.util.EmptySortedSet;
import io.github.fabricators_of_create.porting_lib.util.ItemStackUtil;
import it.unimi.dsi.fastutil.objects.ObjectAVLTreeSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import javax.annotation.Nullable;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;

public class ItemStackHandler
implements SlottedStackStorage,
INBTSerializable<class_2487> {
    private final List<ItemStackHandlerSlot> slots;
    private final SortedSet<ItemStackHandlerSlot> nonEmptySlots;
    private final Map<class_1792, SortedSet<ItemStackHandlerSlot>> lookup;

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int stacks) {
        this(ItemStackUtil.createEmptyStackArray(stacks));
    }

    public ItemStackHandler(class_1799[] stacks) {
        this.slots = new ArrayList<ItemStackHandlerSlot>(stacks.length);
        this.nonEmptySlots = ItemStackHandler.createSlotSet();
        this.lookup = new HashMap<class_1792, SortedSet<ItemStackHandlerSlot>>();
        for (int i = 0; i < stacks.length; ++i) {
            class_1799 stack = stacks[i];
            this.slots.add(this.makeSlot(i, stack));
        }
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<ItemStackHandlerSlot> itr = this.getInsertableSlotsFor(resource);
        while (itr.hasNext() && (inserted += (slot = itr.next()).insert(resource, maxAmount - inserted, transaction)) < maxAmount) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackHandlerSlot slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        class_1792 item = resource.getItem();
        SortedSet<ItemStackHandlerSlot> slots = this.getSlotsContaining(item);
        if (slots.isEmpty()) {
            return 0L;
        }
        long extracted = 0L;
        Iterator iterator = slots.iterator();
        while (iterator.hasNext() && (extracted += (slot = (ItemStackHandlerSlot)((Object)iterator.next())).extract(resource, maxAmount - extracted, transaction)) < maxAmount) {
        }
        return extracted;
    }

    @Nullable
    public StorageView<ItemVariant> exactView(ItemVariant resource) {
        StoragePreconditions.notBlank((TransferVariant)resource);
        SortedSet<ItemStackHandlerSlot> slots = this.getSlotsContaining(resource.getItem());
        return slots.isEmpty() ? null : (StorageView)slots.first();
    }

    public Iterable<StorageView<ItemVariant>> nonEmptyViews() {
        return this.nonEmptySlots;
    }

    public Iterator<StorageView<ItemVariant>> nonEmptyIterator() {
        return this.nonEmptySlots.iterator();
    }

    public int getSlotCount() {
        return this.slots.size();
    }

    public ItemStackHandlerSlot getSlot(int slot) {
        return this.slots.get(slot);
    }

    public List<SingleSlotStorage<ItemVariant>> getSlots() {
        return this.slots;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        return this.getSlot(slot).getStack();
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.getSlot(slot).setNewStack(stack);
    }

    public ItemVariant getVariantInSlot(int slot) {
        return this.getSlot(slot).getResource();
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.getStackInSlot(slot).method_7914();
    }

    protected int getStackLimit(int slot, ItemVariant resource) {
        return Math.min(this.getSlotLimit(slot), resource.getItem().method_7882());
    }

    protected void onContentsChanged(int slot) {
    }

    public SortedSet<ItemStackHandlerSlot> getSlotsContaining(class_1792 item) {
        return this.lookup.containsKey(item) ? this.lookup.get(item) : EmptySortedSet.cast();
    }

    protected void onLoad() {
    }

    public boolean empty() {
        return this.nonEmptySlots.isEmpty();
    }

    public void setSize(int size) {
        this.slots.clear();
        this.nonEmptySlots.clear();
        this.lookup.clear();
        for (int i = 0; i < size; ++i) {
            this.slots.add(this.makeSlot(i, class_1799.field_8037));
        }
    }

    protected ItemStackHandlerSlot makeSlot(int index, class_1799 stack) {
        return new ItemStackHandlerSlot(index, this, stack);
    }

    public class_2487 serializeNBT() {
        class_2487 nbt = new class_2487();
        nbt.method_10569("Size", this.slots.size());
        class_2499 slots = new class_2499();
        for (ItemStackHandlerSlot slot : this.slots) {
            class_2487 slotTag = slot.save();
            if (slotTag == null) continue;
            slotTag.method_10569("Slot", slot.getIndex());
            slots.add((Object)slotTag);
        }
        nbt.method_10566("Items", (class_2520)slots);
        return nbt;
    }

    public void deserializeNBT(class_2487 nbt) {
        this.setSize(nbt.method_10573("Size", 3) ? nbt.method_10550("Size") : this.slots.size());
        class_2499 slots = nbt.method_10554("Items", 10);
        for (int i = 0; i < slots.size(); ++i) {
            class_2487 slotTag = slots.method_10602(i);
            int index = slotTag.method_10550("Slot");
            if (index < 0 || index >= this.slots.size()) continue;
            this.slots.get(index).load(slotTag);
        }
        this.onLoad();
    }

    void onStackChange(ItemStackHandlerSlot slot, class_1799 oldStack, class_1799 newStack) {
        if (class_1799.method_7984((class_1799)oldStack, (class_1799)newStack)) {
            return;
        }
        SortedSet<ItemStackHandlerSlot> oldItemSlots = this.getSlotsContaining(oldStack.method_7909());
        if (!oldItemSlots.isEmpty()) {
            oldItemSlots.remove((Object)slot);
        }
        this.lookup.computeIfAbsent(newStack.method_7909(), $ -> ItemStackHandler.createSlotSet()).add(slot);
        if (oldStack.method_7960()) {
            this.nonEmptySlots.add(slot);
        } else if (newStack.method_7960()) {
            this.nonEmptySlots.remove((Object)slot);
        }
    }

    void initSlot(ItemStackHandlerSlot slot) {
        class_1799 stack = slot.getStack();
        this.lookup.computeIfAbsent(stack.method_7909(), $ -> ItemStackHandler.createSlotSet()).add(slot);
        if (!stack.method_7960()) {
            this.nonEmptySlots.add(slot);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + String.valueOf(this.slots) + "]";
    }

    private Iterator<ItemStackHandlerSlot> getInsertableSlotsFor(ItemVariant variant) {
        SortedSet<ItemStackHandlerSlot> slots = this.getSlotsContaining(variant.getItem());
        SortedSet<ItemStackHandlerSlot> emptySlots = this.getSlotsContaining(class_1802.field_8162);
        if (slots.isEmpty()) {
            return emptySlots.isEmpty() ? Collections.emptyIterator() : emptySlots.iterator();
        }
        return emptySlots.isEmpty() ? slots.iterator() : new DualSortedSetIterator<ItemStackHandlerSlot>(slots, emptySlots);
    }

    private static SortedSet<ItemStackHandlerSlot> createSlotSet() {
        return new ObjectAVLTreeSet(Comparator.comparingInt(ItemStackHandlerSlot::getIndex));
    }
}

